document.addEventListener('DOMContentLoaded', function() {
  // 获取当前标签页信息
  chrome.tabs.query({active: true, currentWindow: true}, function(tabs) {
    const currentTab = tabs[0];
    const url = currentTab.url;
    const title = currentTab.title;
    
    // 设置网站名称
    document.getElementById('siteName').textContent = title;
    
    // 获取favicon
    const favicon = currentTab.favIconUrl || './assets/default-favicon.png';
    document.getElementById('favicon').src = favicon;
    
    // 生成二维码
    new QRCode(document.getElementById('qrcode'), {
      text: url,
      width: 200,
      height: 200,
      colorDark: '#000000',
      colorLight: '#ffffff',
      correctLevel: QRCode.CorrectLevel.H
    });
  });
}); 