# 网页二维码 Chrome 扩展

一个优雅的 Chrome 扩展，可以为当前浏览的网页快速生成二维码。

## 功能特点

- 自动生成当前页面的二维码
- 二维码中心显示网站 favicon
- 简洁优雅的苹果风格界面设计
- 显示当前网站名称

## 安装说明

### 开发模式安装

1. 下载或克隆本仓库到本地
2. 打开 Chrome 浏览器，进入扩展管理页面：`chrome://extensions/`
3. 开启右上角的"开发者模式"
4. 点击"加载已解压的扩展程序"
5. 选择本项目的目录

### 目录结构

web-qrcode-extension/
├── manifest.json # 扩展配置文件
├── popup.html # 弹出页面
├── popup.js # 弹出页面逻辑
├── style.css # 样式文件
├── README.md # 说明文档
├── assets/ # 资源文件目录
│ └── default-favicon.png # 默认网站图标
├── icons/ # 扩展图标目录
│ ├── icon16.png # 16x16像素图标
│ ├── icon48.png # 48x48像素图标
│ └── icon128.png # 128x128像素图标
└── lib/ # 第三方库目录
└── qrcode.min.js # 二维码生成库


## 使用方法

1. 安装扩展后，在 Chrome 浏览器右上角会出现扩展图标
2. 浏览任意网页时，点击扩展图标
3. 弹出窗口中会显示当前网页的二维码
4. 使用手机扫描二维码即可在移动设备上打开当前网页

## 技术栈

- HTML5
- CSS3
- JavaScript
- Chrome Extension API
- QRCode.js

## 开发说明

### 环境要求

- Chrome 浏览器
- 基本的 Web 开发环境

### 开发步骤

1. 克隆仓库：

bash
git clone [仓库地址]
cd web-qrcode-extension


2. 准备资源文件：
- 在 `lib` 目录下放入 `qrcode.min.js`
- 在 `assets` 目录下放入 `default-favicon.png`
- 在 `icons` 目录下放入三种尺寸的图标

3. 加载扩展：
- 打开 Chrome 扩展管理页面
- 开启��发者模式
- 加载已解压的扩展程序

### 调试方法

- 右键点击扩展图标，选择"检查弹出内容"可以打开开发者工具
- 在扩展管理页面点击"重新加载"可以刷新扩展
- 查看 Console 面板可以看到相关日志信息

## 许可证

MIT License

## 贡献指南

欢迎提交 Issue 和 Pull Request 来帮助改进这个项目。

## 作者

[你的名字/组织名称]

## 更新日志

### v1.0.0
- 初始版本发布
- 实现基本的二维码生成功能
- 添加网站 favicon 显示
- 实现苹果风格界面设计